/*
 * InfoEntryDisplay.cpp
 *
 *  Created on: 03.11.2009
 *      Author: stefan.detter
 */

#include "InfoEntry.h"

#include <QFont>
#include <QPixmap>
#include <QBrush>


TreeItem::TYPE InfoEntry::itemType() const
{
	return INFO;
}

TreeItem::DISPLAY_TYPE InfoEntry::displayType() const
{
	return m_type;
}

QVariant InfoEntry::data(int column, int role) const
{
	switch(role)
	{
		case Qt::TextAlignmentRole:
		{
			return int(Qt::AlignLeft /*| Qt::AlignVCenter*/);
			break;
		}

		case Qt::DisplayRole:
		{
			switch(m_type)
			{
			case VALUE:
				switch(column)
				{
				case 0:
					if(m_value.isNull())
						return m_key;
					else
                        return m_key + "  ->  " + m_value.toString();
				}
				break;

			case PROGRESSBAR:
				switch(column)
				{
				case 0:
					return m_key;
				case 1:
					return m_value;
				}
				break;
			}
			break;
		}

        case Qt::DecorationRole:
        {
            if((TreeItem::COLUMN_INDEX)column == COL_ID && !m_decorator.isEmpty())
            {
                return QPixmap(m_decorator);
            }

            break;
        }

		case Qt::FontRole:
		{
			break;
		}
	}

	return QVariant();
}


int InfoEntry::informationRowCount () const
{
	return m_parent->informationRowCount();
}

QVariant InfoEntry::information (int row, int column, int role) const
{
	return m_parent->information(row, column, role);
}

QList<int> InfoEntry::informationSpan() const
{
	return m_parent->informationSpan();
}


int InfoEntry::progressBarMin() const
{
	return m_progressBarMin;
}

int InfoEntry::progressBarMax() const
{
	return m_progressBarMax;
}

QString InfoEntry::progressBarText() const
{
	return m_progressBarText;
}
